
' ##############################################################################
' #
' # File:        E1430.BAS
' # RCS:         "@(#)$Revision: 1.1 $ $Date: 94/03/17 11:40:42 $"
' # Description: header file for using E1430 DLL from BASIC
' # Language:    BASIC
' # Package:     E1430
' # Status:      "@(#)$State: Exp $"
' #
' # (C) Copyright 1994, Hewlett-Packard Company, all rights reserved.
' #
' ##############################################################################
' #
' # This is the header file defining the E1430 DLL library interface.
' #
' # When calling functions with array arguments from BASIC, pass the
' # first element of the array, eg Data[0].
' #
' # Revisions:
' #
' ##############################################################################




' defines for address offsets of registers from module base address

Global Const E1430_VXI_ID_REG = &H0
Global Const E1430_VXI_DEVICE_TYPE_REG = &H2
Global Const E1430_VXI_STATUS_REG = &H4
Global Const E1430_VXI_CONTROL_REG = &H4
Global Const E1430_ANALOG_SETUP_REG = &H6
Global Const E1430_INPUT_OFFSET_REG = &H8
Global Const E1430_MEAS_CONTROL_REG = &HA
Global Const E1430_DATA_FORMAT_REG = &HC
Global Const E1430_IRQ_CONFIG_0_REG = &H14
Global Const E1430_IRQ_CONFIG_1_REG = &H16
Global Const E1430_HP_PORT_CONTROL_REG = &H18
Global Const E1430_HP_COMMON_REG = &H1A
Global Const E1430_TRIGGER_SETUP_REG = &H1A
Global Const E1430_HP_DESCRIPTION_REG = &H1C
Global Const E1430_TRIGGER_BLOCKSIZE_REG = &H1C
Global Const E1430_HP_SUBCLASS_REG = &H1E
Global Const E1430_TRIGGER_OFFSET_LO_REG = &H1E
Global Const E1430_HP_SEND_DATA_REG = &H22
Global Const E1430_TIMING_SETUP_REG = &H24
Global Const E1430_ADC_CONTROL_REG = &H26
Global Const E1430_TRIGGER_PASSOUT_REG = &H28
Global Const E1430_DECIMATION_CNTLAT_0_REG = &H28
Global Const E1430_DECIMATION_RESET_REG = &H2A
Global Const E1430_DECIMATION_CNTLAT_1_REG = &H2A
Global Const E1430_DECIMATION_CAPTURE_REG = &H2C
Global Const E1430_DECIMATION_CNTLAT_2_REG = &H2C
Global Const E1430_DECIMATION_CNTLAT_3_REG = &H2E
Global Const E1430_ZOOM_PHASE_1_REG = &H30
Global Const E1430_ZOOM_PHASE_0_REG = &H32
Global Const E1430_ZOOM_INTERP_3_REG = &H34
Global Const E1430_ZOOM_INTERP_2_REG = &H36
Global Const E1430_ZOOM_INTERP_1_REG = &H38
Global Const E1430_ZOOM_INTERP_0_REG = &H3A
Global Const E1430_ZOOM_CONTROL_REG = &H3C
Global Const E1430_LO_TRANSFER_REG = &H3E

' defines for display_register
Global Const E1430_IMAGE_REGISTER = 0
Global Const E1430_CARD_REGISTER = 1

' defines for analog input
Global Const E1430_COUPLING_AC = 100
Global Const E1430_COUPLING_DC = 101

Global Const E1430_ANTIALIAS_ON = 110
Global Const E1430_ANTIALIAS_OFF = 111

Global Const E1430_INPUT_HI_CONN = 120
Global Const E1430_INPUT_HI_GROUND = 121
Global Const E1430_INPUT_LO_FLOAT = 122
Global Const E1430_INPUT_LO_GROUND = 123

' defines for timing setup parameters
Global Const E1430_ADC_CLOCK_INTERNAL = 200
Global Const E1430_ADC_CLOCK_EXTERNAL = 201

Global Const E1430_DSP_CLOCK_INTERNAL = 210
Global Const E1430_DSP_CLOCK_ADC = 211

Global Const E1430_MULTI_SYNC_ON = 220
Global Const E1430_MULTI_SYNC_OFF = 221

Global Const E1430_MASTER_CLOCK_ON = 240
Global Const E1430_MASTER_CLOCK_OFF = 241

' defines for data I/O parameters
Global Const E1430_SEND_PORT_VME = 300
Global Const E1430_SEND_PORT_LBUS = 301

Global Const E1430_APPEND_STATUS_OFF = 310
Global Const E1430_APPEND_STATUS_ON = 311

Global Const E1430_DATA_TYPE_REAL = 320
Global Const E1430_DATA_TYPE_COMPLEX = 321

Global Const E1430_DATA_SIZE_16 = 330
Global Const E1430_DATA_SIZE_32 = 331

Global Const E1430_BLOCK_MODE = 340
Global Const E1430_CONTINUOUS_MODE = 341

Global Const E1430_LBUS_GENERATE = 351
Global Const E1430_LBUS_APPEND = 352
Global Const E1430_LBUS_INSERT = 353
Global Const E1430_LBUS_PIPELINE = 354

' defines for reset states for LBUS
Global Const E1430_RESET_LBUS_ON = 360
Global Const E1430_RESET_LBUS_OFF = 361

' Defines for triggering parameters
Global Const E1430_TRIGGER_SOURCE_AUTO = 400
Global Const E1430_TRIGGER_SOURCE_EXT = 401
Global Const E1430_TRIGGER_SOURCE_ADC = 402
Global Const E1430_TRIGGER_SOURCE_MAG = 403
Global Const E1430_TRIGGER_SOURCE_OFF = 404

Global Const E1430_TRIGGER_SLOPE_POS = 410
Global Const E1430_TRIGGER_SLOPE_NEG = 411

' defines for decimation filter parameters
Global Const E1430_DECIMATION_ON = 600
Global Const E1430_DECIMATION_OFF = 601

Global Const E1430_PASS_TAG_24 = 610
Global Const E1430_PASS_TAG_32 = 611

Global Const E1430_ONEPASS = 620
Global Const E1430_MULTIPASS = 621

' defines for zoom parameters
Global Const E1430_ZOOM_ON = 700
Global Const E1430_ZOOM_OFF = 701

' defines for data reread parameters
Global Const E1430_DATA_REREAD_ON = 800
Global Const E1430_DATA_REREAD_OFF = 801


' Defines for bit positions in the measurement status register
Global Const E1430_MEAS_STATUS_STATE_MASK = 3
Global Const E1430_MEAS_STATUS_IDLE_STATE = 0
Global Const E1430_MEAS_STATUS_ARM_STATE = 1
Global Const E1430_MEAS_STATUS_MEAS_STATE = 2
Global Const E1430_MEAS_STATUS_TRIG_STATE = 3

Global Const E1430_MEAS_STATUS_MEM_MASK = &H30
Global Const E1430_MEAS_STATUS_CLOCK_MASK = &H40
Global Const E1430_MEAS_STATUS_SYNC_VALID = &H80
Global Const E1430_MEAS_STATUS_READ_VALID = &H100
Global Const E1430_MEAS_STATUS_BLOCK_READY = &H200
Global Const E1430_MEAS_STATUS_ARMED = &H400
Global Const E1430_MEAS_STATUS_MEAS_DONE = &H800
Global Const E1430_MEAS_STATUS_OVERLOAD = &H1000
Global Const E1430_MEAS_STATUS_ADC_ERROR = &H2000
Global Const E1430_MEAS_STATUS_MODID = &H4000

' defines for fifo memory size
Global Const E1430_MEM_SIZE_8 = &H0
Global Const E1430_MEM_SIZE_16 = &H10
Global Const E1430_MEM_SIZE_32 = &H20
Global Const E1430_MEM_SIZE_64 = &H30

' defines for clock frequency
Global Const E1430_CLOCK_FREQ_1000 = &H0
Global Const E1430_CLOCK_FREQ_1024 = &H40


' defines for bit positions in interrupt mask
Global Const E1430_INTR_READ_VALID = &H100
Global Const E1430_INTR_BLOCK_READY = &H200
Global Const E1430_INTR_MODULE_ARMED = &H400
Global Const E1430_INTR_MEAS_DONE = &H800
Global Const E1430_INTR_INPUT_OVERLOAD = &H1000
Global Const E1430_INTR_ADC_ERROR = &H2000

' defines for checkla parameter in restore_state_file()
Global Const E1430_CHECK_LA_MISMATCH = 200
Global Const E1430_IGNORE_LA_MISMATCH = 201

' defines for flag parameter for e1430_diagnostics routine
Global Const MEM_TEST_FLAG = 1
Global Const REG_ACCESS_TEST_FLAG = 2


' ***************** INITIALIZATION ********************
Declare Function e1430_init_io_driver Lib "E1430.DLL" () As Integer

Declare Function e1430_create_module_group Lib "E1430.DLL" (ByVal numMods As Integer, laArray As Integer) As Integer

Declare Function e1430_delete_module_group Lib "E1430.DLL" (ByVal groupID As Integer) As Integer

Declare Function e1430_delete_all_module_groups Lib "E1430.DLL" (void) As Integer

Declare Function e1430_reset_module Lib "E1430.DLL" (ByVal groupID As Integer) As Integer

Declare Function e1430_reset_dsp Lib "E1430.DLL" (ByVal groupID As Integer) As Integer

Declare Function e1430_reset_lbus Lib "E1430.DLL" (ByVal groupID As Integer, ByVal state As Integer) As Integer

Declare Function e1430_set_timeout Lib "E1430.DLL" (ByVal timeout As Long) As Integer

Declare Function e1430_get_timeout Lib "E1430.DLL" (timeout As Long) As Integer


' ***************** TIMING ********************
Declare Function e1430_set_clock_mode Lib "E1430.DLL" (ByVal groupID As Integer, ByVal multiSync As Integer, ByVal adcClock As Integer, ByVal dspClock As Integer) As Integer

Declare Function e1430_set_clock_master_mode Lib "E1430.DLL" (ByVal la As Integer, ByVal state As Integer) As Integer

Declare Function e1430_get_clock_master_mode Lib "E1430.DLL" (ByVal la As Integer, state As Integer) As Integer


Declare Function e1430_set_adc_clock Lib "E1430.DLL" (ByVal groupID As Integer, ByVal adcClock As Integer) As Integer

Declare Function e1430_get_adc_clock Lib "E1430.DLL" (ByVal groupID As Integer, sourcePtr As Integer) As Integer
    
Declare Function e1430_set_dsp_clock Lib "E1430.DLL" (ByVal groupID As Integer, ByVal dspClock As Integer) As Integer

Declare Function e1430_get_dsp_clock Lib "E1430.DLL" (ByVal groupID As Integer, sourcePtr As Integer) As Integer
    
Declare Function e1430_set_multi_sync Lib "E1430.DLL" (ByVal groupID As Integer, ByVal state As Integer) As Integer

Declare Function e1430_get_multi_sync Lib "E1430.DLL" (ByVal groupID As Integer, statePtr As Integer) As Integer

Declare Function e1430_set_sample_clock_freq_la Lib "E1430.DLL" (ByVal la As Integer, ByVal freq As Double) As Integer

Declare Function e1430_get_sample_clock_freq_la Lib "E1430.DLL" (ByVal la As Integer, freqPtr As Double) As Integer


' ***************** ANALOG ********************
Declare Function e1430_auto_zero Lib "E1430.DLL" (ByVal groupID As Integer) As Integer

Declare Function e1430_auto_range Lib "E1430.DLL" (ByVal groupID As Integer, ByVal delay As Double) As Integer


Declare Function e1430_set_analog_input Lib "E1430.DLL" (ByVal groupID As Integer, ByVal range As Double, ByVal coupling As Integer, ByVal filter As Integer, ByVal inHi As Integer, ByVal inLo As Integer) As Integer


Declare Function e1430_set_range Lib "E1430.DLL" (ByVal groupID As Integer, ByVal range As Double) As Integer

Declare Function e1430_get_range Lib "E1430.DLL" (ByVal groupID As Integer, rangePtr As Double) As Integer

Declare Function e1430_set_range_la Lib "E1430.DLL" (ByVal la As Integer, ByVal range As Double) As Integer

Declare Function e1430_get_range_la Lib "E1430.DLL" (ByVal la As Integer, rangePtr As Double) As Integer

Declare Function e1430_set_anti_alias_filter Lib "E1430.DLL" (ByVal groupID As Integer, ByVal state As Integer) As Integer

Declare Function e1430_get_anti_alias_filter Lib "E1430.DLL" (ByVal groupID As Integer, statePtr As Integer) As Integer

Declare Function e1430_set_coupling Lib "E1430.DLL" (ByVal groupID As Integer, ByVal coupling As Integer) As Integer


Declare Function e1430_get_coupling Lib "E1430.DLL" (ByVal groupID As Integer, couplingPtr As Integer) As Integer

Declare Function e1430_set_input_high Lib "E1430.DLL" (ByVal groupID As Integer, ByVal source As Integer) As Integer

Declare Function e1430_get_input_high Lib "E1430.DLL" (ByVal groupID As Integer, sourcePtr As Integer) As Integer

Declare Function e1430_set_input_low Lib "E1430.DLL" (ByVal groupID As Integer, ByVal source As Integer) As Integer

Declare Function e1430_get_input_low Lib "E1430.DLL" (ByVal groupID As Integer, sourcePtr As Integer) As Integer

Declare Function e1430_set_input_offset Lib "E1430.DLL" (ByVal la As Integer, ByVal offset As Double) As Integer

Declare Function e1430_get_input_offset Lib "E1430.DLL" (ByVal la As Integer, offsetPtr As Double) As Integer


' ***************** DATA FORMAT ********************
Declare Function e1430_set_data_format Lib "E1430.DLL" (ByVal groupID As Integer, ByVal typ As Integer, ByVal size As Integer, ByVal mode As Integer, ByVal blocksize As Long, ByVal appendx As Integer) As Integer

Declare Function e1430_set_data_port Lib "E1430.DLL" (ByVal groupID As Integer, ByVal port As Integer) As Integer

Declare Function e1430_get_data_port Lib "E1430.DLL" (ByVal groupID As Integer, portPtr As Integer) As Integer

Declare Function e1430_set_data_mode Lib "E1430.DLL" (ByVal groupID As Integer, ByVal mode As Integer) As Integer

Declare Function e1430_get_data_mode Lib "E1430.DLL" (ByVal groupID As Integer, modePtr As Integer) As Integer

Declare Function e1430_set_lbus_mode Lib "E1430.DLL" (ByVal la As Integer, ByVal mode As Integer) As Integer

Declare Function e1430_get_lbus_mode Lib "E1430.DLL" (ByVal la As Integer, modePtr As Integer) As Integer

Declare Function e1430_set_append_status Lib "E1430.DLL" (ByVal groupID As Integer, ByVal appendx As Integer) As Integer

Declare Function e1430_get_append_status Lib "E1430.DLL" (ByVal groupID As Integer, appendPtr As Integer) As Integer

Declare Function e1430_set_data_type Lib "E1430.DLL" (ByVal groupID As Integer, ByVal typ As Integer) As Integer

Declare Function e1430_get_data_type Lib "E1430.DLL" (ByVal groupID As Integer, typePtr As Integer) As Integer

Declare Function e1430_set_data_size Lib "E1430.DLL" (ByVal groupID As Integer, ByVal size As Integer) As Integer

Declare Function e1430_get_data_size Lib "E1430.DLL" (ByVal groupID As Integer, sizePtr As Integer) As Integer

Declare Function e1430_set_blocksize Lib "E1430.DLL" (ByVal groupID As Integer, ByVal size As Long) As Integer

Declare Function e1430_get_blocksize Lib "E1430.DLL" (ByVal groupID As Integer, sizePtr As Long) As Integer

Declare Function e1430_set_data_reread Lib "E1430.DLL" (ByVal groupID As Integer, ByVal reread As Integer) As Integer

Declare Function e1430_get_data_reread Lib "E1430.DLL" (ByVal groupID As Integer, rereadPtr As Integer) As Integer

' ***************** TRIGGER ********************

Declare Function e1430_set_trigger_mode Lib "E1430.DLL" (ByVal groupID As Integer, ByVal source As Integer, ByVal delay As Long, ByVal level As Double, ByVal slope As Integer) As Integer

Declare Function e1430_get_trigger_phase Lib "E1430.DLL" (ByVal la As Integer, phasePtr As Double) As Integer

Declare Function e1430_set_trigger_source Lib "E1430.DLL" (ByVal groupID As Integer, ByVal source As Integer) As Integer

Declare Function e1430_get_trigger_source Lib "E1430.DLL" (ByVal groupID As Integer, sourcePtr As Integer) As Integer

Declare Function e1430_set_trigger_slope Lib "E1430.DLL" (ByVal groupID As Integer, ByVal slope As Integer) As Integer

Declare Function e1430_get_trigger_slope Lib "E1430.DLL" (ByVal groupID As Integer, slopePtr As Integer) As Integer

Declare Function e1430_set_trigger_level_adc Lib "E1430.DLL" (ByVal groupID As Integer, ByVal level As Double) As Integer

Declare Function e1430_set_trigger_level_mag Lib "E1430.DLL" (ByVal groupID As Integer, ByVal level As Double) As Integer

Declare Function e1430_get_trigger_level_adc Lib "E1430.DLL" (ByVal groupID As Integer, levelPtr As Double) As Integer

Declare Function e1430_get_trigger_level_mag Lib "E1430.DLL" (ByVal groupID As Integer, levelPtr As Double) As Integer

Declare Function e1430_set_trigger_delay Lib "E1430.DLL" (ByVal groupID As Integer, ByVal delay As Long) As Integer

Declare Function e1430_get_trigger_delay Lib "E1430.DLL" (ByVal groupID As Integer, delayPtr As Long) As Integer

Declare Function e1430_get_trigger_bandwidth Lib "E1430.DLL" (ByVal groupID As Integer, bwPtr As Integer) As Integer


' ***************** MEASUREMENT ********************

Declare Function e1430_abort_meas Lib "E1430.DLL" (ByVal groupID As Integer) As Integer

Declare Function e1430_arm_module Lib "E1430.DLL" (ByVal groupID As Integer) As Integer

Declare Function e1430_trigger_module Lib "E1430.DLL" (ByVal groupID As Integer) As Integer

Declare Function e1430_set_center_frequency Lib "E1430.DLL" (ByVal groupID As Integer, ByVal freq As Double) As Integer

Declare Function e1430_set_center_freq_bits Lib "E1430.DLL" (ByVal groupID As Integer, ByVal freq As Double) As Integer

Declare Function e1430_get_center_frequency Lib "E1430.DLL" (ByVal groupID As Integer, freqPtr As Double) As Integer


Declare Function e1430_set_span_zoom Lib "E1430.DLL" (ByVal groupID As Integer, ByVal centerFreq As Double, ByVal span As Double, ByVal zoom As Integer) As Integer

Declare Function e1430_get_span Lib "E1430.DLL" (ByVal groupID As Integer, spanPtr As Double) As Integer

Declare Function e1430_get_status Lib "E1430.DLL" (ByVal la As Integer, statusPtr As Integer) As Integer

' ***************** INTERRUPTS ********************

Declare Function e1430_set_interrupt Lib "E1430.DLL" (ByVal groupID As Integer, ByVal intrNum As Integer, ByVal priority As Integer, ByVal mask As Integer) As Integer

Declare Function e1430_set_interrupt_priority Lib "E1430.DLL" (ByVal groupID As Integer, ByVal intrNum As Integer, ByVal priority As Integer) As Integer

Declare Function e1430_get_interrupt_priority Lib "E1430.DLL" (ByVal groupID As Integer, ByVal intrNum As Integer, priorityPtr As Integer) As Integer

Declare Function e1430_set_interrupt_mask Lib "E1430.DLL" (ByVal groupID As Integer, ByVal intrNum As Integer, ByVal mask As Integer) As Integer

Declare Function e1430_get_interrupt_mask Lib "E1430.DLL" (ByVal groupID As Integer, ByVal intrNum As Integer, maskPtr As Integer) As Integer


' ***************** DECIMATION FILTER ********************
Declare Function e1430_set_decimation_filter Lib "E1430.DLL" (ByVal groupID As Integer, ByVal level As Integer, ByVal state As Integer, ByVal outputx As Integer, ByVal tag As Integer) As Integer


Declare Function e1430_set_decimation_bandwidth Lib "E1430.DLL" (ByVal groupID As Integer, ByVal dataBw As Integer, ByVal triggerBw As Integer) As Integer

Declare Function e1430_get_decimation_bandwidth Lib "E1430.DLL" (ByVal groupID As Integer, bwPtr As Integer) As Integer


Declare Function e1430_set_decimation_state Lib "E1430.DLL" (ByVal groupID As Integer, ByVal state As Integer) As Integer

Declare Function e1430_get_decimation_state Lib "E1430.DLL" (ByVal groupID As Integer, statePtr As Integer) As Integer


Declare Function e1430_set_decimation_output Lib "E1430.DLL" (ByVal groupID As Integer, ByVal out As Integer) As Integer

Declare Function e1430_get_decimation_output Lib "E1430.DLL" (ByVal groupID As Integer, outPtr As Integer) As Integer


Declare Function e1430_set_decimation_passtag Lib "E1430.DLL" (ByVal groupID As Integer, ByVal tag As Integer) As Integer

Declare Function e1430_get_decimation_passtag Lib "E1430.DLL" (ByVal groupID As Integer, tagPtr As Integer) As Integer



' ***************** LOW LEVEL ********************

Declare Function e1430_write_register Lib "E1430.DLL" (ByVal groupID As Integer, ByVal offset As Integer, ByVal dat As Integer) As Integer

Declare Function e1430_write_register_image Lib "E1430.DLL" (ByVal la As Integer, ByVal offset As Integer, ByVal dat As Integer) As Integer

Declare Function e1430_write_register_card Lib "E1430.DLL" (ByVal la As Integer, ByVal offset As Integer, ByVal dat As Integer) As Integer

Declare Function e1430_read_register_card Lib "E1430.DLL" (ByVal la As Integer, ByVal offset As Integer, dat As Integer) As Integer

Declare Function e1430_read_register_image Lib "E1430.DLL" (ByVal la As Integer, ByVal offset As Integer, dat As Integer) As Integer


' ***************** READ DATA ********************
Declare Function e1430_read_raw_data Lib "E1430.DLL" (ByVal la As Integer, buf As Integer, ByVal blocksize As Long, adcOverload As Integer, adcError As Integer, actualCnt As Long) As Integer

Declare Function e1430_read_float32_data Lib "E1430.DLL" (ByVal la As Integer, buf As Single, ByVal blocksize As Long, adcOverload As Integer, adcError As Integer, actualCnt As Long) As Integer

Declare Function e1430_read_float64_data Lib "E1430.DLL" (ByVal la As Integer, buf As Double, ByVal blocksize As Long, adcOverload As Integer, adcError As Integer, actualCnt As Long) As Integer

Declare Function e1430_get_fifo_block_data_size Lib "E1430.DLL" (ByVal la As Integer, size As Long) As Integer

Declare Function e1430_get_scale_la Lib "E1430.DLL" (ByVal la As Integer, scalePtr As Double) As Integer

Declare Function e1430_total_data_size Lib "E1430.DLL" (ByVal groupID As Integer, size As Long) As Integer

Declare Function e1430_get_fifo_size Lib "E1430.DLL" (ByVal la As Integer, size As Long) As Integer

Declare Function e1430_get_fifo_max_blocksize Lib "E1430.DLL" (ByVal groupID As Integer, size As Long) As Integer

Declare Function e1430_get_fifo_data_point_size Lib "E1430.DLL" (ByVal la As Integer, size As Integer) As Integer



' ***************** DEBUG ********************
Declare Function e1430_debug_level Lib "E1430.DLL" (ByVal level As Integer) As Integer

Declare Function e1430_display_module_state Lib "E1430.DLL" (ByVal groupID As Integer) As Integer

Declare Function e1430_display_register Lib "E1430.DLL" (ByVal groupID As Integer, ByVal offset As Integer, ByVal card As Integer) As Integer


' ***************** DIAGNOSTICS ********************
Declare Function e1430_diagnostics Lib "E1430.DLL" (ByVal la As Integer, ByVal memTestFlag As Integer) As Integer

Declare Function e1430_test_logical_address Lib "E1430.DLL" (ByVal la As Integer) As Integer

Declare Function e1430_test_register_access Lib "E1430.DLL" (ByVal la As Integer) As Integer

Declare Function e1430_test_meas_control Lib "E1430.DLL" (ByVal la As Integer) As Integer

Declare Function e1430_test_timing_setup Lib "E1430.DLL" (ByVal la As Integer) As Integer

Declare Function e1430_test_fifo_memory Lib "E1430.DLL" (ByVal la As Integer) As Integer

Declare Function e1430_test_data_collection Lib "E1430.DLL" (ByVal la As Integer) As Integer

Declare Function e1430_test_interrupts Lib "E1430.DLL" (ByVal la As Integer) As Integer

Declare Function e1430_test_trigger Lib "E1430.DLL" (ByVal la As Integer) As Integer



' ***************** RESAMPLING ********************

Declare Function e1430_get_filter_data Lib "E1430.DLL" (dat As Single, filt_data As Single, FIR_reg As Single, ByVal clock As Integer, ByVal size As Long, ByVal filter As Integer, ByVal bw_num As Integer) As Integer


Declare Function e1430_get_resample_data Lib "E1430.DLL" (x As Single, resamp_data As Single, rec As Single, ByVal clock As Integer, ByVal num As Long, ByVal filter As Integer, ByVal bw_num As Integer, ByVal dt As Single, re As Single, timex As Single, out_size As Long) As Integer



' *************** ERRORS ********************
Declare Function e1430_fill_error_string Lib "E1430.DLL" (stringa As Integer) As Integer

Declare Function e1430_fill_software_rev Lib "E1430.DLL" (stringa As Integer) As Integer

Declare Function e1430_print_errors Lib "E1430.DLL" (ByVal state As Integer) As Integer

Function get_e1430_error () As String
    ' gets the E1430 error string as an array of Integers,
    ' then copies it to a BASIC string.
    ReDim stringa(0 To 255) As Integer
    Dim leng As Integer
    Dim strng As String
    leng = e1430_fill_error_string(stringa(0))
    For i = 0 To leng - 1
      strng = strng + Chr(stringa(i))
    Next i
    get_e1430_error = strng
End Function

Function get_e1430_rev () As String
    ' gets the E1430 library revision string an array of Integers,
    ' then copies it to a BASIC string.
    ReDim stringa(0 To 255) As Integer
    Dim leng As Integer
    Dim strng As String
    leng = e1430_fill_software_rev(stringa(0))
    For i = 0 To leng - 1
      strng = strng + Chr(stringa(i))
    Next i
    get_e1430_rev = strng
End Function

